/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.detectoritem;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.detectorentity.CompareType;
import com.lothrazar.cyclic.block.detectoritem.ContainerDetectorItem;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileDetectorItem
extends TileBlockEntityCyclic
implements MenuProvider {
    private static final int PER_TICK = 10;
    public static final int MAX_RANGE = 32;
    private int rangeX = 5;
    private int rangeY = 1;
    private int rangeZ = 5;
    private int limitUntilRedstone = 0;
    private CompareType compType = CompareType.GREATER;
    private boolean isPoweredNow = false;

    public TileDetectorItem(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.DETECTOR_ITEM.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileDetectorItem e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileDetectorItem e) {
        e.tick();
    }

    public void tick() {
        --this.timer;
        if (this.f_58857_.f_46443_ || this.timer > 0) {
            return;
        }
        this.timer = 10;
        int entitiesFound = this.getCountInRange();
        boolean trigger = false;
        switch (this.compType) {
            case LESS: {
                trigger = entitiesFound < this.limitUntilRedstone;
                break;
            }
            case GREATER: {
                trigger = entitiesFound > this.limitUntilRedstone;
                break;
            }
            case EQUAL: {
                trigger = entitiesFound == this.limitUntilRedstone;
                break;
            }
        }
        if (this.isPoweredNow != trigger) {
            this.isPoweredNow = trigger;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
            try {
                this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            }
            catch (Throwable e) {
                ModCyclic.LOGGER.error("Detector: State change error in adjacent block ", e);
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerDetectorItem(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public boolean isPowered() {
        return this.isPoweredNow;
    }

    private int getCountInRange() {
        AABB entityRange = this.getRange();
        int entitiesFound = 0;
        List entityList = this.f_58857_.m_45976_(ItemEntity.class, entityRange);
        for (ItemEntity item : entityList) {
            entitiesFound += item.m_32055_().m_41613_();
        }
        return entitiesFound;
    }

    private AABB getRange() {
        double x = this.f_58858_.m_123341_();
        double y = this.f_58858_.m_123342_();
        double z = this.f_58858_.m_123343_();
        AABB entityRange = new AABB(x - (double)this.rangeX, y - (double)this.rangeY, z - (double)this.rangeZ, x + (double)this.rangeX + 1.0, y + (double)this.rangeY, z + (double)this.rangeZ + 1.0);
        return entityRange;
    }

    @Override
    public int getField(int f) {
        switch (Fields.values()[f]) {
            case GREATERTHAN: {
                return this.compType.ordinal();
            }
            case LIMIT: {
                return this.limitUntilRedstone;
            }
            case RANGEX: {
                return this.rangeX;
            }
            case RANGEY: {
                return this.rangeY;
            }
            case RANGEZ: {
                return this.rangeZ;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        Fields f = Fields.values()[field];
        if (f == Fields.RANGEX || f == Fields.RANGEY || f == Fields.RANGEZ) {
            if (value > 32) {
                value = 32;
            }
            if (value < 1) {
                value = 1;
            }
        }
        switch (f) {
            case GREATERTHAN: {
                if (value >= CompareType.values().length) {
                    value = 0;
                }
                if (value < 0) {
                    value = CompareType.values().length - 1;
                }
                this.compType = CompareType.values()[value];
                break;
            }
            case LIMIT: {
                if (value > 999) {
                    value = 32;
                }
                if (value < 0) {
                    value = 0;
                }
                this.limitUntilRedstone = value;
                break;
            }
            case RANGEX: {
                this.rangeX = value;
                break;
            }
            case RANGEY: {
                this.rangeY = value;
                break;
            }
            case RANGEZ: {
                this.rangeZ = value;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.rangeX = tag.m_128451_("ox");
        this.rangeY = tag.m_128451_("oy");
        this.rangeZ = tag.m_128451_("oz");
        this.limitUntilRedstone = tag.m_128451_("limit");
        int cType = tag.m_128451_("compare");
        if (cType >= 0 && cType < CompareType.values().length) {
            this.compType = CompareType.values()[cType];
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("ox", this.rangeX);
        tag.m_128405_("oy", this.rangeY);
        tag.m_128405_("oz", this.rangeZ);
        tag.m_128405_("limit", this.limitUntilRedstone);
        tag.m_128405_("compare", this.compType.ordinal());
        super.m_183515_(tag);
    }

    public List<BlockPos> getShape() {
        return ShapeUtil.getShape(this.getRange(), this.f_58858_.m_123342_());
    }

    static enum Fields {
        GREATERTHAN,
        LIMIT,
        RANGEX,
        RANGEY,
        RANGEZ,
        RENDER;

    }
}

